<?php
$pdo = Db::pdo();
$memberId = (int)($_SESSION['auth']['id'] ?? 0);

// auto-create wallet kalau belum ada
$st = $pdo->prepare("SELECT balance FROM wallets WHERE member_id=? LIMIT 1");
$st->execute([$memberId]);
$wallet = $st->fetch();
if (!$wallet) {
  $pdo->prepare("INSERT INTO wallets (member_id, balance) VALUES (?, 0.00)")->execute([$memberId]);
  $wallet = ['balance' => '0.00'];
}
$balance = (float)$wallet['balance'];

// ===== Filters =====
$q = trim($_GET['q'] ?? '');
$type = trim($_GET['type'] ?? ''); // credit/debit
$from = trim($_GET['from'] ?? ''); // YYYY-MM-DD
$to   = trim($_GET['to'] ?? '');   // YYYY-MM-DD

// pagination
$perPage = 25;
$pageNum = (int)($_GET['p'] ?? 1);
if ($pageNum < 1) $pageNum = 1;
$offset = ($pageNum - 1) * $perPage;

// build where
$where = "member_id = ?";
$params = [$memberId];

if ($type === 'credit' || $type === 'debit') {
  $where .= " AND type = ?";
  $params[] = $type;
}
if ($q !== '') {
  $where .= " AND (note LIKE ? OR source LIKE ? OR ref_table LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
  $params[] = "%$q%";
}
if ($from !== '') {
  $where .= " AND created_at >= ?";
  $params[] = $from . " 00:00:00";
}
if ($to !== '') {
  $where .= " AND created_at <= ?";
  $params[] = $to . " 23:59:59";
}

// total
$st = $pdo->prepare("SELECT COUNT(*) FROM wallet_transactions WHERE $where");
$st->execute($params);
$total = (int)$st->fetchColumn();
$totalPages = (int)ceil(max(1, $total) / $perPage);

// rows
$sql = "
  SELECT id, type, amount, source, ref_table, ref_id, note, created_at
  FROM wallet_transactions
  WHERE $where
  ORDER BY id DESC
  LIMIT $perPage OFFSET $offset
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

// ringkas periode (optional)
$st = $pdo->prepare("
  SELECT
    COALESCE(SUM(CASE WHEN type='credit' THEN amount END),0) AS total_credit,
    COALESCE(SUM(CASE WHEN type='debit' THEN amount END),0) AS total_debit
  FROM wallet_transactions
  WHERE $where
");
$st->execute($params);
$sum = $st->fetch(PDO::FETCH_ASSOC);
$totalCredit = (float)($sum['total_credit'] ?? 0);
$totalDebit  = (float)($sum['total_debit'] ?? 0);

function rupiah($n) {
  return 'Rp ' . number_format((float)$n, 0, ',', '.');
}
?>

<div class="row g-3">
  <div class="col-12">
    <h4 class="mb-0">Wallet</h4>
    <div class="text-secondary">Saldo & riwayat transaksi wallet kamu.</div>
  </div>

  <!-- Summary cards -->
  <div class="col-12 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Saldo Saat Ini</div>
        <div class="fs-3 fw-semibold"><?= e(rupiah($balance)) ?></div>
        <div class="small text-secondary mt-1">Update otomatis dari bonus & transaksi.</div>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Total Credit (filter aktif)</div>
        <div class="fs-5 fw-semibold text-success"><?= e(rupiah($totalCredit)) ?></div>
        <div class="small text-secondary mt-1">Masuk: sponsor/pairing/dll.</div>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Total Debit (filter aktif)</div>
        <div class="fs-5 fw-semibold text-danger"><?= e(rupiah($totalDebit)) ?></div>
        <div class="small text-secondary mt-1">Keluar: withdraw/dll.</div>
      </div>
    </div>
  </div>

  <!-- Filters -->
  <div class="col-12">
    <form class="card border-0 shadow-sm" method="get" action="member.php">
      <input type="hidden" name="page" value="wallet">
      <div class="card-body">
        <div class="row g-2">
          <div class="col-12 col-md-3">
            <label class="form-label mb-1">Type</label>
            <select class="form-select" name="type">
              <option value="">Semua</option>
              <option value="credit" <?= $type==='credit'?'selected':'' ?>>Credit</option>
              <option value="debit"  <?= $type==='debit'?'selected':'' ?>>Debit</option>
            </select>
          </div>

          <div class="col-12 col-md-3">
            <label class="form-label mb-1">Dari</label>
            <input type="date" class="form-control" name="from" value="<?= e($from) ?>">
          </div>

          <div class="col-12 col-md-3">
            <label class="form-label mb-1">Sampai</label>
            <input type="date" class="form-control" name="to" value="<?= e($to) ?>">
          </div>

          <div class="col-12 col-md-3">
            <label class="form-label mb-1">Cari</label>
            <input class="form-control" name="q" placeholder="note/source..." value="<?= e($q) ?>">
          </div>

          <div class="col-12 col-md-3">
            <button class="btn btn-dark w-100 mt-1">
              <i class="bi bi-funnel me-1"></i> Filter
            </button>
          </div>

          <div class="col-12 col-md-3">
            <a class="btn btn-outline-secondary w-100 mt-1" href="member.php?page=wallet">
              Reset
            </a>
          </div>

        </div>
      </div>
    </form>
  </div>

  <!-- Table -->
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Riwayat Transaksi</h6>
          <div class="small text-secondary">Total: <?= (int)$total ?></div>
        </div>

        <div class="table-responsive">
          <table class="table table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th>Waktu</th>
                <th>Tipe</th>
                <th>Amount</th>
                <th>Source</th>
                <th>Note</th>
                <th>Ref</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td class="small"><?= e($r['created_at']) ?></td>
                  <td>
                    <span class="badge <?= $r['type']==='credit' ? 'bg-success' : 'bg-danger' ?>">
                      <?= e(strtoupper($r['type'])) ?>
                    </span>
                  </td>
                  <td class="fw-semibold">
                    <?= e(rupiah($r['amount'])) ?>
                  </td>
                  <td class="small"><?= e($r['source'] ?? '-') ?></td>
                  <td class="small"><?= e($r['note'] ?? '-') ?></td>
                  <td class="small text-secondary">
                    <?php if (!empty($r['ref_table']) && !empty($r['ref_id'])): ?>
                      <?= e($r['ref_table']) ?> #<?= (int)$r['ref_id'] ?>
                    <?php else: ?>
                      -
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>

              <?php if (empty($rows)): ?>
                <tr>
                  <td colspan="6" class="text-center text-secondary py-3">
                    Belum ada transaksi.
                  </td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>

        <?php if ($totalPages > 1): ?>
          <nav class="mt-2">
            <ul class="pagination pagination-sm mb-0">
              <?php
                $base = "member.php?page=wallet"
                      . "&type=" . urlencode($type)
                      . "&from=" . urlencode($from)
                      . "&to=" . urlencode($to)
                      . "&q=" . urlencode($q);
              ?>
              <?php for ($i=1; $i<=$totalPages; $i++): ?>
                <li class="page-item <?= $i===$pageNum ? 'active' : '' ?>">
                  <a class="page-link" href="<?= e($base . "&p=" . $i) ?>"><?= $i ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>

      </div>
    </div>
  </div>
</div>
